/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.maptrades;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.maptrades.StructureSpecificMaps;
import com.telepathicgrunt.repurposedstructures.misc.maptrades.VillagerMapObj;
import com.telepathicgrunt.repurposedstructures.misc.maptrades.WanderingTraderMapObj;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_20;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5321;

public final class StructureMapTradesEvents {
    private StructureMapTradesEvents() {
    }

    public static void setupTradeEvent() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            StructureMapTradesEvents.forgeWandererEvent();
            StructureMapTradesEvents.forgeVillagerEvents();
        });
    }

    private static void forgeWandererEvent() {
        class_2371 generic = class_2371.method_10211();
        class_2371 rare = class_2371.method_10211();
        generic.addAll(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(1)));
        rare.addAll(Arrays.asList((class_3853.class_1652[])class_3853.field_17724.get(2)));
        StructureMapTradesEvents.onWandererTradesEvent((List<class_3853.class_1652>)generic, (List<class_3853.class_1652>)rare);
        class_3853.field_17724.put(1, (Object)generic.toArray(new class_3853.class_1652[0]));
        class_3853.field_17724.put(2, (Object)rare.toArray(new class_3853.class_1652[0]));
    }

    private static void forgeVillagerEvents() {
        for (Map.Entry prof : class_2378.field_17167.method_29722()) {
            Int2ObjectMap trades = (Int2ObjectMap)class_3853.field_17067.getOrDefault(prof.getValue(), new Int2ObjectOpenHashMap());
            Int2ObjectOpenHashMap mutableTrades = new Int2ObjectOpenHashMap();
            for (int i = 1; i <= trades.size(); ++i) {
                mutableTrades.put(i, (Object)class_2371.method_10211());
            }
            trades.int2ObjectEntrySet().forEach(arg_0 -> StructureMapTradesEvents.lambda$forgeVillagerEvents$1((Int2ObjectMap)mutableTrades, arg_0));
            StructureMapTradesEvents.onVillagerTradesEvent((Int2ObjectMap<List<class_3853.class_1652>>)mutableTrades, ((class_5321)prof.getKey()).method_29177().toString());
            Int2ObjectOpenHashMap newTrades = new Int2ObjectOpenHashMap();
            mutableTrades.int2ObjectEntrySet().forEach(arg_0 -> StructureMapTradesEvents.lambda$forgeVillagerEvents$2((Int2ObjectMap)newTrades, arg_0));
            class_3853.field_17067.put((class_3852)prof.getValue(), newTrades);
        }
    }

    public static void onVillagerTradesEvent(Int2ObjectMap<List<class_3853.class_1652>> trades, String type) {
        if (RepurposedStructures.structureMapManager.VILLAGER_MAP_TRADES.containsKey(type)) {
            for (VillagerMapObj mapTrade : RepurposedStructures.structureMapManager.VILLAGER_MAP_TRADES.get(type)) {
                class_20.class_21 icon;
                try {
                    icon = class_20.class_21.valueOf((String)mapTrade.mapIcon.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    RepurposedStructures.LOGGER.error((Object)e);
                    icon = class_20.class_21.field_88;
                }
                ((List)trades.get(mapTrade.tradeLevel)).add(new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
            }
        }
    }

    public static void onWandererTradesEvent(List<class_3853.class_1652> generic, List<class_3853.class_1652> rare) {
        for (Map.Entry<WanderingTraderMapObj.TRADE_TYPE, List<WanderingTraderMapObj>> tradeEntry : RepurposedStructures.structureMapManager.WANDERING_TRADER_MAP_TRADES.entrySet()) {
            for (WanderingTraderMapObj mapTrade : tradeEntry.getValue()) {
                class_20.class_21 icon;
                try {
                    icon = class_20.class_21.valueOf((String)mapTrade.mapIcon.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    RepurposedStructures.LOGGER.error((Object)e);
                    icon = class_20.class_21.field_88;
                }
                if (tradeEntry.getKey() == WanderingTraderMapObj.TRADE_TYPE.RARE) {
                    rare.add(new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
                    continue;
                }
                if (tradeEntry.getKey() != WanderingTraderMapObj.TRADE_TYPE.COMMON) continue;
                generic.add(new StructureSpecificMaps.TreasureMapForEmeralds(mapTrade.emeraldsRequired, mapTrade.structure, mapTrade.mapName, icon, mapTrade.tradesAllowed, mapTrade.xpReward, mapTrade.spawnRegionSearchRadius));
            }
        }
    }

    private static /* synthetic */ void lambda$forgeVillagerEvents$2(Int2ObjectMap newTrades, Int2ObjectMap.Entry e) {
        newTrades.put(e.getIntKey(), (Object)((List)e.getValue()).toArray(new class_3853.class_1652[0]));
    }

    private static /* synthetic */ void lambda$forgeVillagerEvents$1(Int2ObjectMap mutableTrades, Int2ObjectMap.Entry e) {
        Arrays.stream((class_3853.class_1652[])e.getValue()).forEach(((List)mutableTrades.get(e.getIntKey()))::add);
    }
}

